﻿using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class StudentDoc : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.StudentDoc, BO.StudentDoc>
    {

        internal StudentDoc(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal StudentDoc(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.StudentDoc.DBD) { }

        internal List<BO.StudentDoc> Restore(BO.Student Student)
        {
            return InternalRestoreList((int)DBD.StudentDoc.Commands.RestoreByStudentID,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Student.ID;
            });
        }

        internal BO.StudentDoc Restore(BO.Student Student, string Name)
        {
            return InternalRestoreOne((int)DBD.StudentDoc.Commands.RestoreByStudentIDName,
             delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
             {
                 Command["StudentID"].Value = Student.ID;
                 Command["Name"].Value = Name;
             });
        }

        internal bool Remove(BO.Student Student)
        {
            bool _return = false;
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.StudentDoc.Commands.RemoveByStudentID,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Student.ID;
                Command["EditDate"].Value = DateTime.Now;
                Command["EditUser"].Value = Environment.User.ID;
            });

            if (_command != null)
            {
                if (_command.ResultParam != null)
                {
                    _return = _command.ResultParamValue >= 0 ? true : false;
                }
                else
                {
                    _return = true;
                }
            }
            return _return;
        }
    }
}